# Bitget Trading Bot

Bot trading otomatis untuk Bitget dengan sistem Grid Trading dan DCA (Averaging).

## Fitur

### Trading Modes
- **Grid Trading**: Membuat grid order otomatis pada level harga tertentu
- **DCA (Dollar Cost Averaging)**: Averaging otomatis ketika harga turun
- **Kombinasi**: Gunakan keduanya bersamaan

### Risk Management
- Stop Loss (persentase dari balance)
- Max Drawdown
- Daily Loss Limit
- Max Open Positions
- Trailing Stop

### Notifikasi
- Telegram notifications untuk:
  - Trade execution
  - Profit/Loss
  - Errors
  - Daily summary

### Multi-User
- Sistem login dengan role admin/user
- Setiap user memiliki API key dan settings sendiri
- Admin dapat menambah/mengelola user

## Requirements

- PHP 7.4 atau lebih tinggi
- MySQL 5.7 atau lebih tinggi
- cPanel hosting dengan akses:
  - MySQL Database
  - Cron Jobs
  - File Manager

## Instalasi

### 1. Upload Files

Upload semua file ke folder `public_html/trading-bot/` di cPanel Anda.

### 2. Create Database

1. Login ke cPanel
2. Buka "MySQL Database Wizard"
3. Buat database baru (contoh: `tradingbot_db`)
4. Buat user database (contoh: `tradingbot_user`)
5. Berikan semua privileges

### 3. Import Database Schema

1. Buka phpMyAdmin di cPanel
2. Pilih database yang baru dibuat
3. Klik tab "Import"
4. Pilih file `database/schema.sql`
5. Klik "Go"

### 4. Konfigurasi Database

Edit file `config/database.php`:

```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'tradingbot_db');      // Nama database Anda
define('DB_USER', 'tradingbot_user');    // Username database Anda
define('DB_PASS', 'your_password_here'); // Password database Anda
```

### 5. Setup Cron Job

1. Buka "Cron Jobs" di cPanel
2. Tambahkan cron job baru:

```
* * * * * /usr/bin/php /home/username/public_html/trading-bot/cron/trading_bot.php >> /home/username/public_html/trading-bot/logs/cron.log 2>&1
```

Ganti `username` dengan username cPanel Anda.

### 6. Konfigurasi Bitget API

1. Login ke akun Bitget Anda
2. Buka API Management
3. Buat API Key baru dengan permissions:
   - Read
   - Spot Trade
4. Copy API Key, Secret, dan Passphrase
5. Masukkan di Settings page bot

### 7. Konfigurasi Telegram (Optional)

1. Buka @BotFather di Telegram
2. Buat bot baru dengan `/newbot`
3. Copy bot token
4. Dapatkan Chat ID dengan:
   - Kirim pesan ke @userinfobot
   - Atau buka `https://api.telegram.org/bot<TOKEN>/getUpdates`
5. Masukkan di Telegram Settings

## Default Login

- **Username**: `admin`
- **Password**: `admin123`

**PENTING**: Ganti password default segera setelah login!

## Penggunaan

### 1. Login
Buka `https://app.lompodoe.cloud/login.php`

### 2. Konfigurasi API
- Masuk ke menu Settings → API Settings
- Masukkan API Key, Secret, dan Passphrase Bitget
- Pilih Testnet atau Live

### 3. Konfigurasi Trading
- Pilih trading pair (contoh: BTCUSDT)
- Pilih timeframe
- Aktifkan Grid dan/atau DCA
- Atur parameter trading

### 4. Risk Management
- Atur Stop Loss percentage
- Atur Max Drawdown
- Atur Daily Loss Limit
- Atur Max Open Positions

### 5. Start Bot
- Klik tombol "Start Bot" di Settings
- Bot akan berjalan setiap menit via cron job

## Struktur Folder

```
trading-bot/
├── config/
│   └── database.php          # Database configuration
├── includes/
│   ├── Auth.php              # Authentication class
│   ├── BitgetAPI.php         # Bitget API integration
│   ├── Database.php          # Database connection
│   ├── Telegram.php          # Telegram notifications
│   └── TradingEngine.php     # Main trading logic
├── cron/
│   └── trading_bot.php       # Cron job script
├── database/
│   └── schema.sql            # Database schema
├── logs/
│   └── cron.log              # Cron execution logs
├── public/                   # Web root
│   ├── index.php             # Dashboard
│   ├── login.php             # Login page
│   ├── logout.php            # Logout
│   ├── settings.php          # Settings page
│   ├── trading.php           # Trading monitor
│   ├── history.php           # Trade history
│   ├── users.php             # User management (admin)
│   └── .htaccess             # Apache config
└── README.md
```

## Mode Test vs Live

### Test Mode
- Menggunakan balance virtual
- Tidak melakukan trading real
- Cocok untuk testing strategi
- Balance default: 10 USDT

### Live Mode
- Menggunakan balance real di Bitget
- Trading dengan uang sungguhan
- Pastikan API key sudah benar
- Balance sesuai akun Bitget Anda

## Grid Trading

### Cara Kerja
1. Bot membuat grid order pada level harga tertentu
2. Buy orders di bawah harga saat ini
3. Sell orders di atas harga saat ini
4. Ketika order terisi, bot membuat order berlawanan

### Parameter
- **Grid Levels**: Jumlah level grid (default: 10)
- **Investment**: Total investasi per grid (USDT)
- **Dynamic Grid**: Menyesuaikan range berdasarkan volatilitas

## DCA (Averaging)

### Cara Kerja
1. Bot membeli posisi awal
2. Jika harga turun X%, bot membeli lagi dengan quantity lebih besar
3. Proses berlanjut sampai level DCA tercapai atau TP tercapai

### Parameter
- **DCA Levels**: Jumlah level averaging (default: 5)
- **Drop Percentage**: Persentase penurunan untuk trigger DCA (default: 5%)
- **Multiplier**: Pengali quantity untuk level berikutnya (default: 1.5x)

## Take Profit

Take Profit dihitung dari **persentase balance**, bukan persentase trade individual.

Contoh:
- Balance: 500 USDT
- TP: 2%
- Bot akan tutup posisi ketika profit mencapai 10 USDT (2% dari 500)

## Troubleshooting

### Bot tidak berjalan
1. Cek cron job sudah di-setup
2. Cek logs di `logs/cron.log`
3. Pastikan API key valid
4. Cek bot status di Settings

### API Error
1. Pastikan API key, secret, dan passphrase benar
2. Cek API permissions di Bitget
3. Pastikan IP whitelist sudah diatur (jika digunakan)

### Telegram notifikasi tidak terkirim
1. Cek bot token dan chat ID
2. Pastikan notifikasi enabled di settings
3. Test koneksi dengan mengirim pesan manual

### Database connection error
1. Cek konfigurasi di `config/database.php`
2. Pastikan database dan user sudah dibuat
3. Cek privileges user database

## Keamanan

1. **Ganti password default segera**
2. **Gunakan HTTPS** (install SSL certificate)
3. **IP Whitelist** untuk API Bitget
4. **Jangan share API credentials**
5. **Regular backup database**

## Support

Jika ada masalah atau pertanyaan, silakan hubungi:
- Email: admin@lompodoe.cloud
- Telegram: @your_telegram

## Disclaimer

Trading cryptocurrency memiliki risiko tinggi. Bot ini dibuat untuk membantu trading otomatis, tetapi tidak menjamin profit. Selalu:
- Gunakan mode test terlebih dahulu
- Mulai dengan modal kecil
- Pantau performa secara berkala
- Siapkan risk management yang baik

**Gunakan bot ini dengan risiko Anda sendiri.**

## Lisensi

MIT License - Dapat digunakan dan dimodifikasi sesuai kebutuhan.

---

Dibuat dengan ❤️ untuk komunitas trading Indonesia.
